/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.client.components.selection.SelectionList;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import me.codexadrian.tempad.api.options.TempadOption;
import me.codexadrian.tempad.client.config.TempadClientConfig;
import me.codexadrian.tempad.client.widgets.NewLocationModal;
import me.codexadrian.tempad.client.widgets.TemporaryWidget;
import me.codexadrian.tempad.client.widgets.TextEntry;
import me.codexadrian.tempad.common.config.ConfigCache;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.items.TempadItem;
import me.codexadrian.tempad.common.network.NetworkHandler;
import me.codexadrian.tempad.common.network.messages.c2s.AddLocationPacket;
import me.codexadrian.tempad.common.network.messages.c2s.DeleteLocationPacket;
import me.codexadrian.tempad.common.network.messages.c2s.ExportLocationPacket;
import me.codexadrian.tempad.common.network.messages.c2s.FavoriteLocationPacket;
import me.codexadrian.tempad.common.network.messages.c2s.SummonTimedoorPacket;
import me.codexadrian.tempad.common.utils.TeleportUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsolidatedScreen
extends class_437 {
    private static final class_2960 SCREEN = new class_2960("tempad", "textures/widget/tempad_screen.png");
    private static final int TEMPAD_WIDTH = 249;
    private static final int TEMPAD_HEIGHT = 138;
    protected final List<TemporaryWidget> temporaryWidgets = new ArrayList<TemporaryWidget>();
    private final List<LocationData> locations;
    private UUID favorite;
    private LocationData selectedLocation;
    private SelectionList<TextEntry> informationPanel;
    private SelectionList<TextEntry> locationPanel;
    private class_4185 favoriteButton;
    private class_4185 unfavoriteButton;
    private class_4185 downloadButton;
    private class_4185 deleteButton;
    private class_4185 teleportButton;

    public ConsolidatedScreen(List<LocationData> locations, UUID favorite) {
        super(class_2561.method_30163((String)""));
        this.locations = locations;
        this.favorite = favorite;
    }

    protected void method_25426() {
        super.method_25426();
        int offset = 3;
        int cornerX = (this.field_22789 - 249) / 2;
        int cornerY = (this.field_22790 - 138) / 2;
        this.informationPanel = (SelectionList)this.method_37063((class_364)new SelectionList(cornerX + 16, cornerY + 33, 91, 78, 10, textEntry -> {}));
        this.locationPanel = (SelectionList)this.method_37063((class_364)new SelectionList(cornerX + 129, cornerY + 31, 91, 92, 10, textEntry -> {
            if (textEntry != null && textEntry.data != null) {
                this.selectedLocation = textEntry.data;
                this.informationPanel.updateEntries(List.of(new TextEntry((class_2561)class_2561.method_43470((String)this.selectedLocation.getName())), new TextEntry((class_2561)class_2561.method_43469((String)"gui.tempad.x", (Object[])new Object[]{class_3532.method_15375((float)this.selectedLocation.getBlockPos().method_10263())})), new TextEntry((class_2561)class_2561.method_43469((String)"gui.tempad.y", (Object[])new Object[]{class_3532.method_15375((float)this.selectedLocation.getBlockPos().method_10264())})), new TextEntry((class_2561)class_2561.method_43469((String)"gui.tempad.z", (Object[])new Object[]{class_3532.method_15375((float)this.selectedLocation.getBlockPos().method_10260())})), new TextEntry((class_2561)class_2561.method_43469((String)"gui.tempad.dimension", (Object[])new Object[]{class_2561.method_43471((String)this.selectedLocation.getLevelKey().method_29177().method_42093("dimension"))}))));
                if (this.selectedLocation.getId().equals(this.favorite)) {
                    this.favoriteButton.field_22764 = false;
                    this.unfavoriteButton.field_22764 = true;
                } else {
                    this.favoriteButton.field_22764 = true;
                    this.unfavoriteButton.field_22764 = false;
                }
                this.downloadButton.field_22764 = true;
                this.deleteButton.field_22764 = true;
                this.teleportButton.field_22764 = true;
                this.deleteButton.field_22763 = this.selectedLocation.isDeletable();
                if (this.selectedLocation.isDeletable()) {
                    this.deleteButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.tempad.delete")));
                } else {
                    this.deleteButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.tempad.delete_disabled")));
                }
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    TempadItem tempadItem;
                    class_1799 itemInHand = TeleportUtils.findTempad((class_1657)this.field_22787.field_1724);
                    class_1792 class_17922 = itemInHand.method_7909();
                    boolean isTempadUsable = class_17922 instanceof TempadItem && (tempadItem = (TempadItem)class_17922).getOption().canTimedoorOpen((class_1657)this.field_22787.field_1724, itemInHand);
                    boolean bl = this.teleportButton.field_22763 = this.selectedLocation.isTeleportable() && TeleportUtils.mayTeleport(this.selectedLocation.getLevelKey(), (class_1657)this.field_22787.field_1724) && isTempadUsable;
                    if (this.selectedLocation.isTeleportable()) {
                        this.teleportButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.tempad.teleport")));
                    } else {
                        this.teleportButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.tempad.teleport_disabled")));
                    }
                    boolean bl2 = this.downloadButton.field_22763 = this.selectedLocation.isDownloadable() && ConfigCache.allowExporting && (!ConfigCache.consumeCooldown || isTempadUsable);
                    if (this.selectedLocation.isDownloadable()) {
                        this.downloadButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.tempad.download")));
                    } else {
                        this.downloadButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.tempad.download_disabled")));
                    }
                }
            }
        }));
        if (this.locations.isEmpty()) {
            this.locationPanel.updateEntries(List.of(new TextEntry((class_2561)class_2561.method_43471((String)"gui.tempad.no_locations.first_line")), new TextEntry((class_2561)class_2561.method_43471((String)"gui.tempad.no_locations.second_line"))));
        } else {
            this.locationPanel.updateEntries(this.locations.stream().map(locationData -> new TextEntry((LocationData)locationData, locData -> locData.getId().equals(this.favorite))).toList());
            this.informationPanel.updateEntries(List.of(new TextEntry((class_2561)class_2561.method_43471((String)"gui.tempad.no_selection.first_line")), new TextEntry((class_2561)class_2561.method_43471((String)"gui.tempad.no_selection.second_line"))));
        }
        class_342 editBox = new class_342(this.field_22793, cornerX + 139, cornerY + 16, 66, 12, (class_2561)class_2561.method_43471((String)"gui.tempad.search_field"));
        editBox.method_1858(false);
        editBox.method_47404((class_2561)class_2561.method_43471((String)"gui.tempad.search_field"));
        editBox.method_1868(TempadClientConfig.color);
        if (!this.locations.isEmpty()) {
            editBox.method_1863(string -> this.locationPanel.updateEntries(this.locations.stream().filter(locationData -> locationData.getName().toLowerCase().contains(string.toLowerCase())).map(locationData -> new TextEntry((LocationData)locationData, locData -> locData.getId().equals(this.favorite))).toList()));
        }
        this.method_37063((class_364)editBox);
        this.favoriteButton = (class_4185)this.method_37063((class_364)new TempadButton(cornerX + 46, cornerY + 110, 14, 14, (class_2561)class_2561.method_43471((String)"gui.tempad.favorite"), button -> this.favoriteAction(), 0));
        this.favoriteButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.tempad.favorite")));
        this.favoriteButton.field_22764 = false;
        this.unfavoriteButton = (class_4185)this.method_37063((class_364)new TempadButton(cornerX + 46, cornerY + 110, 14, 14, (class_2561)class_2561.method_43471((String)"gui.tempad.unfavorite"), button -> this.favoriteAction(), 1));
        this.unfavoriteButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.tempad.unfavorite")));
        this.unfavoriteButton.field_22764 = false;
        this.downloadButton = (class_4185)this.method_37063((class_364)new TempadButton(cornerX + 62, cornerY + 110, 14, 14, (class_2561)class_2561.method_43471((String)"gui.tempad.download"), button -> this.exportAction(), 2));
        this.downloadButton.field_22764 = false;
        this.deleteButton = (class_4185)this.method_37063((class_364)new TempadButton(cornerX + 78, cornerY + 110, 14, 14, (class_2561)class_2561.method_43471((String)"gui.tempad.delete"), button -> this.deleteAction(), 3));
        this.deleteButton.field_22764 = false;
        this.teleportButton = (class_4185)this.method_37063((class_364)new TempadButton(cornerX + 94, cornerY + 110, 14, 14, (class_2561)class_2561.method_43471((String)"gui.tempad.teleport"), button -> this.teleportAction(), 4));
        this.teleportButton.field_22764 = false;
        ((TempadButton)this.method_37063((class_364)new TempadButton(cornerX + 208, cornerY + 14, 12, 12, (class_2561)class_2561.method_43471((String)"gui.tempad.add_location"), button -> this.openNewLocationModal(), 5))).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.tempad.add_location")));
    }

    private void favoriteAction() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            if (this.selectedLocation.getId().equals(this.favorite)) {
                this.favorite = null;
                this.favoriteButton.field_22764 = true;
                this.unfavoriteButton.field_22764 = false;
            } else {
                this.favorite = this.selectedLocation.getId();
                this.favoriteButton.field_22764 = false;
                this.unfavoriteButton.field_22764 = true;
            }
            NetworkHandler.CHANNEL.sendToServer((Packet)new FavoriteLocationPacket(this.favorite));
        }
    }

    private void teleportAction() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            NetworkHandler.CHANNEL.sendToServer((Packet)new SummonTimedoorPacket(this.selectedLocation.getId(), TempadClientConfig.color));
            class_310.method_1551().method_1507(null);
        }
    }

    private void deleteAction() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            NetworkHandler.CHANNEL.sendToServer((Packet)new DeleteLocationPacket(this.selectedLocation.getId()));
            this.locations.removeIf(locationData -> locationData.getId().equals(this.selectedLocation.getId()));
            this.selectedLocation = null;
            this.locationPanel.updateEntries(this.locations.stream().map(locationData -> new TextEntry((LocationData)locationData, locData -> locData.getId().equals(this.favorite))).toList());
            this.informationPanel.updateEntries(List.of(new TextEntry((class_2561)class_2561.method_43471((String)"gui.tempad.no_selection.first_line")), new TextEntry((class_2561)class_2561.method_43471((String)"gui.tempad.no_selection.second_line"))));
            this.favoriteButton.field_22764 = false;
            this.unfavoriteButton.field_22764 = false;
            this.downloadButton.field_22764 = false;
            this.deleteButton.field_22764 = false;
            this.teleportButton.field_22764 = false;
        }
    }

    private void exportAction() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null && ConfigCache.allowExporting) {
            class_310.method_1551().method_1507(null);
            NetworkHandler.CHANNEL.sendToServer((Packet)new ExportLocationPacket(this.selectedLocation.getId()));
        }
    }

    private void openNewLocationModal() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.findOrCreateEditWidget();
        }
    }

    private void newLocationAction(String name) {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_310.method_1551().method_1507(null);
            NetworkHandler.CHANNEL.sendToServer((Packet)new AddLocationPacket(name));
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        graphics.method_25293(SCREEN, (this.field_22789 - 249) / 2, (this.field_22790 - 138) / 2, 249, 138, 0.0f, 0.0f, 249, 138, 256, 256);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        int barHeight = 0;
        class_1799 tempad = TeleportUtils.findTempad((class_1657)this.field_22787.field_1724);
        class_1792 class_17922 = tempad.method_7909();
        if (class_17922 instanceof TempadItem) {
            TempadItem item = (TempadItem)class_17922;
            TempadOption option = item.getOption();
            barHeight = option.isDurabilityBarVisible(tempad) ? (int)(option.getPercentage(tempad) * 54.0) : (option.canTimedoorOpen((class_1657)this.field_22787.field_1724, tempad) ? 54 : 0);
            graphics.method_25293(SCREEN, (this.field_22789 - 249) / 2 + 234, (this.field_22790 - 138) / 2 + 42 + 54 - barHeight, 6, barHeight, 249.0f, (float)(54 - barHeight), 6, barHeight, 256, 256);
            if (mouseX >= (this.field_22789 - 249) / 2 + 234 && mouseX <= (this.field_22789 - 249) / 2 + 240 && mouseY >= (this.field_22790 - 138) / 2 + 42 && mouseY <= (this.field_22790 - 138) / 2 + 96) {
                ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
                option.addToolTip(tempad, (class_1937)this.field_22787.field_1687, tooltip, (class_1836)class_1836.field_41070);
                graphics.method_51437(this.field_22793, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    public <R extends class_4068 & TemporaryWidget> R addTemporary(R renderable) {
        this.method_37060(renderable);
        this.temporaryWidgets.add(renderable);
        return renderable;
    }

    @Nullable
    public class_364 method_25399() {
        boolean visible = false;
        for (TemporaryWidget widget : this.temporaryWidgets) {
            visible |= widget.isVisible();
            if (!widget.isVisible() || !(widget instanceof class_364)) continue;
            class_364 listener = (class_364)widget;
            return listener;
        }
        if (visible) {
            return null;
        }
        return super.method_25399();
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        ArrayList<class_364> listeners = new ArrayList<class_364>();
        for (TemporaryWidget widget : this.temporaryWidgets) {
            if (!widget.isVisible() || !(widget instanceof class_364)) continue;
            class_364 listener = (class_364)widget;
            listeners.add(listener);
        }
        if (!listeners.isEmpty()) {
            return listeners;
        }
        return super.method_25396();
    }

    public List<TemporaryWidget> temporaryWidgets() {
        return this.temporaryWidgets;
    }

    public void findOrCreateEditWidget() {
        boolean found = false;
        NewLocationModal widget = new NewLocationModal(this.field_22789, this.field_22790, (this.field_22789 - 249) / 2 + 70, (this.field_22790 - 138) / 2 + 54, this::newLocationAction);
        for (TemporaryWidget temporaryWidget : this.temporaryWidgets()) {
            if (!(temporaryWidget instanceof NewLocationModal)) continue;
            NewLocationModal modal = (NewLocationModal)temporaryWidget;
            found = true;
            widget = modal;
            break;
        }
        widget.setVisible(true);
        if (!found) {
            this.addTemporary(widget);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public static class TempadButton
    extends class_4185 {
        private final int buttonOffset;

        protected TempadButton(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress, int buttonOffset) {
            super(x, y, width, height, message, onPress, class_4185.field_40754);
            this.buttonOffset = buttonOffset;
        }

        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            guiGraphics.method_25293(SCREEN, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), (float)(this.buttonOffset * 14), (float)this.getTextureY(), this.method_25368(), this.method_25364(), 256, 256);
        }

        protected int getTextureY() {
            int i = 0;
            if (!this.method_37303()) {
                i = 2;
            } else if (this.method_49606()) {
                i = 1;
            }
            return 138 + i * this.method_25364();
        }
    }
}

